#version 130
#extension GL_EXT_gpu_shader4 : enable
// the version and open GL extension
// should be the first line of the shader
/////////////////////////////////////////////////////////////////////////////////
//  Double truchet ksastroMod01.fsh    by   ksastro  
//https://www.shadertoy.com/view/w3X3Ws
//Licence : Creative Commons Attribution-ShareAlike 4.0
//http://creativecommons.org/licences/by-sa/4.0
// Adapted, trivialy, for use in VGHD player
/////////////////////////////////////////////
uniform float u_Elapsed;    // The elapsed time in seconds
uniform vec2  u_WindowSize; // Window dimensions in pixels

#define iTime u_Elapsed*0.314159  //*0.1666
#define iResolution u_WindowSize

//#define mouse AUTO_MOUSE
//#define MOUSE_SPEED vec2(vec2(0.5,0.577777) * 0.25)
//#define MOUSE_POS   vec2((1.0+cos(iTime*MOUSE_SPEED))*u_WindowSize/2.0)
//#define MOUSE_PRESS vec2(0.0,0.0)
//#define AUTO_MOUSE  vec4( MOUSE_POS, MOUSE_PRESS )
//#define RIGID_SCROLL
// alternatively use static mouse definition
#define iMouse vec4(0.0,0.0, 0.0,0.0)
//#define iMouse vec4(512,256,180,120)
uniform sampler2D texture0;
uniform sampler2D texture1;
uniform sampler2D texture2;
uniform sampler2D texture3;
vec4 texture2D_Fract(sampler2D sampler,vec2 P) {return texture2D(sampler,fract(P));}
vec4 texture2D_Fract(sampler2D sampler,vec2 P, float Bias) {return texture2D(sampler,fract(P),Bias);}
#define texture2D texture2D_Fract

const float EULER_NUMBER = 2.718281828;
const float PI = 3.1415926535;

const vec3 PATTERN_SHIFT = vec3(1254.,935.,715713.);

vec3 paletteBlueMagenta( float t ) {
    vec3 a = vec3(0.6, 0., 0.8);
    vec3 b = vec3(0.4, 0., 0.2);
    vec3 c = vec3(.5, .0, .5);
    vec3 d = vec3(.5,0.,0.);

    return a + b*cos( 6.28318*(c*t+d) );
}
vec3 paletteCyan( float t ) {
    vec3 a = vec3(0., 0.7, 0.7);
    vec3 b = vec3(0., 0.25, 0.25);
    vec3 c = vec3(.5, .5, 0.25);
    vec3 d = vec3(0.5,0.5,- 0.25);

    return a + b*cos( 6.28318*(c*t+d) );
}

uint hashUint (in uint seed)    //murmur type of hash from https://t.ly/bKdP7
{ 
    seed ^= seed >> 17;
    seed *= 0xed5ad4bbU;
    seed ^= seed >> 11;
    seed *= 0xac4c1b51U;
    seed ^= seed >> 15;
    seed *= 0x31848babU;
    seed ^= seed >> 14;
    return seed;
}
uvec2 hashUint(in uvec2 seed)
{
    return uvec2(hashUint(seed.x),hashUint(seed.y));
}

float hashFloat(in float seed)  //(0,1) RNG
{ 
    uint hash = hashUint(uint(seed + PATTERN_SHIFT.x)); 
    return float(hash) / float(0xffffffffu);
}
float hashFloat(in vec2 seed)
{
    seed += PATTERN_SHIFT.xy;
    uint hashX = hashUint(uint(seed.x));
    uint hashXY = hashUint(hashX + uint(seed.y));
    return float(hashXY) / float(0xffffffffu);
}

float Length(vec2 p, float gamma)
{
    return pow((pow(p.x, gamma) + pow(p.y, gamma)), 1./gamma);
}

float sdCircle( vec2 p, vec2 center, float r, float gamma )
{
    return Length((p - center), gamma) - r;
}

vec2 Truchet (vec2 p, float gamma){  //.x is sdf, .y is arg, gamma is power for Length
    vec2 cellID = floor(p);
    float checkerID = mod(cellID.x+cellID.y, 2.)*2.-1.;
    float cellHash = hashFloat(cellID);
    float cellHashBinary = step(0.5, cellHash);
    cellHashBinary = cellHashBinary * 2. - 1.;
    vec2 griduv = fract(p);
    griduv -= 0.5;
    griduv.x *= cellHashBinary;

    bool isTopRight = (griduv.x + griduv.y > 0.);
    vec2 circleCenter = vec2(.5);
    if(!isTopRight) circleCenter *= -1.;

    float sdf;
    sdf = sdCircle(griduv, circleCenter, .5, gamma);
    float arg = atan(griduv.y - circleCenter.y, griduv.x - circleCenter.x);
    arg *= 4.;      //needed for continuity
    arg *= checkerID;   //needed for continuity
    return vec2(sdf, arg);
}

//void mainImage( out vec4 fragColor, in vec2 fragCoord )
///////////////////////////////////////////////////////////////////////////////// 
// need to convert this from a void to a function and call it by adding
// a void main(void) { to the end of the shader
// what type of variable will the function return?, it is a color and needs to be a vec4
// change void to vec4 
//void MainImage(out vec4 fragColor, in vec2 fragCoord) 
vec4 mainImage( out vec4 fragColor, in vec2 fragCoord )
{ 
    float t = iTime * .2; //anim speed
    vec2 uv = (fragCoord.xy * 2. - iResolution.xy)/iResolution.y;
    uv *= 4.;

    

    vec2 truchet1 = Truchet(uv, 2.);
    float sdf = truchet1.x;
    float arg = truchet1.y;
    float thickness = 0.15;
    float amplitude;
    amplitude = exp(-1. * sdf * sdf / (thickness * thickness));
    amplitude = clamp(thickness/(abs(sdf)),0.,1.); //hyperbolic
    if (abs(sdf) > 0.1) amplitude = 0.;
    //if (amplitude < 0.3) amplitude = 0.;

    vec3 col1 = vec3(0.,0.,0.);
    
    col1 += paletteBlueMagenta(arg/PI + 10.*t) * amplitude * 0.8;

    vec2 truchet2 = Truchet(uv + PATTERN_SHIFT.xy + vec2(0.5), 4.);
    sdf = truchet2.x;
    arg = truchet2.y;
    thickness = 0.03;
    amplitude = exp(-1. * sdf * sdf / (thickness * thickness));
    amplitude = clamp(thickness/(abs(sdf)),0.,1.); //hyperbolic
    //if (abs(sdf) > 0.1) amplitude = 0.;
    if (amplitude < 0.6) amplitude = 0.;

    vec3 col2 = vec3(0.);
    
    col2 += paletteCyan(arg/PI + 10.*t) * amplitude * 0.8;

    vec3 col = vec3(0.,0.,0.);
    if (col1.r + col1.g + col1.b == 0.) col = col2;
    if (col2.r + col2.g + col2.b == 0.) col = col1;

    uv += 0.25;

    vec2 cellID = floor(uv);
    float cellHash = hashFloat(cellID);
    float cellHashBinary = step(0.5, cellHash);
    
    if (col1.r + col1.g + col1.b != 0. && col2.r + col2.g + col2.b != 0.) col = cellHashBinary * col1 + (1. - cellHashBinary) * col2;    fragColor = vec4(col, 1.);
/////////////////////////////////////////////////////////////////////////////////
//the function needs to return a value. 
//it needs to be a vec4
//we will return the varable fragColor 
// usual place for fragColor = vec4( color, 1.0 ); bring the } down below 
return fragColor; 
}

///////////////////////////////////////////////////////////////////////////////// 
void main(void) { // this will be run for every pixel of gl_FragCoord.xy
vec4 vTexCoord = gl_TexCoord[0];
vec4 fragColor = vec4(1.0); // initialize variable fragColor as a vec4 
vec4 cc = mainImage(fragColor, gl_FragCoord.xy); // call function mainImage and assign the return vec4 to cc
gl_FragColor = vec4(cc) * gl_Color; // set the pixel to the value of vec4 cc  and..
//gl_FragColor.a = length(gl_FragColor.rgb);
}

// ..uses the values of any Color: or Opacity:
// clauses (and any Animate clauses applied to these properties) 
// appearing in the Sprite, Quad or other node invoking the shader 
// in the .scn file.

